//*****************************************************************************
//
// File:             rmsps.h
//
// Purpose:          Header file for rmsps program.
//
// Author:           Michael Edwards - m@michael-edwards.org
//
// Date:             August 2nd 2001
//
// License:          Copyright (C) 2001 Michael Edwards
//
//                   This file is part of rmsps.  
//
//                   rmsps is free software; you can redistribute it and/or
//                   modify it under the terms of the GNU General Public
//                   License as published by the Free Software Foundation;
//                   either version 2 of the License, or (at your option) any
//                   later version.
//
//                   rmsps is distributed in the hope that it will be useful,
//                   but WITHOUT ANY WARRANTY; without even the implied
//                   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//                   PURPOSE.  See the GNU General Public License for more
//                   details.
//
//                   You should have received a copy of the GNU General Public
//                   License along with rmsps; if not, write to the Free
//                   Software Foundation, Inc., 59 Temple Place, Suite 330,
//                   Boston, MA 02111-1307 USA
//
// $$ Last modified: 13:28:54 Fri Oct 12 2001 W. Europe Daylight Time
//
//*****************************************************************************

#ifndef __RMSPS_H__
#define __RMSPS_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "sndfile.h"
#include "progparams.h"

char* getline(FILE* fp, char* buf);
void stringtrim(char *str);
double getsecs(char* time);
int GetPageParameters(char* line, char* filename, double* times, double* xs); 
int GetProgramParameters(char* line, progparams* pps);
int writeepsfile(char* epsfile, double* times, double* xs, int num_segments,
                 progparams* pps);
int writesegment(FILE* eps, int num_rms_calls, double xstart, double xinc,
                 double yscaler, double starttime, 
                 progparams* pps);
void drawrect(FILE* fp, int x1, int y1, int x2, int y2);
double getrms(sndfile* sf, const int rms_size);
void ruler(double start_secs, double end_secs, double xstart,
           double xend, int fontsize, int yoffset, FILE* epsfile);
char* secs_to_mins(double secs);
void verticalscale(FILE* eps, int num, int height, int width, 
                   const char* shading, int yoffset);
inline void line(FILE* epsfile, double x1, double y1, double x2,
              double y2);
inline void hline(FILE* epsfile, double x1, double y, double x2);
inline void vline(FILE* epsfile, double x, double y1, double y2);
void brokenhline(FILE* epsfile, double x1, double y1, double x2);
double rmslog(double rms, double base);
inline double mylog(double x, double base);
void rulerwritetime(FILE* epsfile, double x, double y, double secs, 
                    double notch_depth);

#endif // __RMSPS_H__

//*****************************************************************************

// EOF rmsps.h

