//*****************************************************************************
//
// File:             progparams.h
//
// Purpose:          Header file for progparams class.
//
// Author:           Michael Edwards - m@michael-edwards.org
//
// Date:             September 19th 2001
//
// License:          Copyright (C) 2001 Michael Edwards
//
//                   This file is part of rmsps.  
//
//                   rmsps is free software; you can redistribute it and/or
//                   modify it under the terms of the GNU General Public
//                   License as published by the Free Software Foundation;
//                   either version 2 of the License, or (at your option) any
//                   later version.
//
//                   rmsps is distributed in the hope that it will be useful,
//                   but WITHOUT ANY WARRANTY; without even the implied
//                   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//                   PURPOSE.  See the GNU General Public License for more
//                   details.
//
//                   You should have received a copy of the GNU General Public
//                   License along with rmsps; if not, write to the Free
//                   Software Foundation, Inc., 59 Temple Place, Suite 330,
//                   Boston, MA 02111-1307 USA
//
// $$ Last modified: 16:54:46 Tue Dec 16 2003 GMT Standard Time
//
//*****************************************************************************

#ifndef __PROGPARAMS_H__
#define __PROGPARAMS_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "sndfile.h"

double getsecs(char* time);
char* stringdowncase(char* string);
void finalslash(char* path);

typedef enum { IN, CM, PT } unit;

class progparams {
public:
    progparams(void);

    virtual ~progparams(void) { };

    int parse(char* params);
    void CheckRequired(void);

    sndfile* GetSoundFile(void) { return &SoundFile; }
    int GetRMSSize(void) const { return RMSSize; }
    double GetRMSScaler(void) const { return RMSScaler; }
    int GetWidth(void) const { return Width; }
    int GetHeight(void) const { return Height; }
    double GetXScale(void) const { return XScale; }
    const char* GetShading(void) const { return Shading; }
    int GetHLines(void) const { return HLines; }
    const char* GetFont(void) const { return Font; }
    const char* GetOutDir(void) const { return OutDir; }
    int GetFontSize(void) const { return FontSize; }
    int GetYOffset(void) const { return YOffset; }
    double GetReadOffset(void) const { return ReadOffset; }
    double GetWriteOffset(void) const { return WriteOffset; }
    double GetLineWidth(void) const { return LineWidth; }
    int GetTimeLine(void) const { return TimeLine; }
    double GetRMSExpt(void) const { return RMSExpt; }

protected:
    // image width in points
    int Width;
    // image height in points
    int Height;
    double XScale; 
    int RMSSize; // samples
    double DefaultRMSSize; // millisecs
    double RMSScaler;
    double RMSExpt;
    char Shading[64]; 
    int HLines;
    char OutDir[512];
    char Font[64];
    int FontSize;
    int YOffset;
    unit Units;
    double ReadOffset;
    double WriteOffset;
    double LineWidth;
    int TimeLine;
    // although this isn't strictly a program parameter, it's handier to have
    // it here than outside the class. 
    sndfile SoundFile;

    int InPoints(double x);
    int GetRMSSize(double ms);
    void missingparam(char* param)
    {
        error("progparams::missingparam", 
              "Missing required parameter: '%s'", param);
    }
};



#endif // __PROGPARAMS_H__

//*****************************************************************************

// EOF sndfile.h
